using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Events;
using DG.Tweening;

public class Chip : MonoBehaviour
{
    [SerializeField] AudioClip AudioClip;
    [SerializeField] int PosY;
    [SerializeField] float Duration;
    private void OnTriggerEnter(Collider other)
    {
        if (other.CompareTag("Player"))
        {
            ChipManager.instance.AddChip();
            Camera.main.GetComponent<AudioSource>().PlayOneShot(AudioClip);
            GetComponent<MeshRenderer>().shadowCastingMode = UnityEngine.Rendering.ShadowCastingMode.Off;
            transform.DOMoveY(PosY, Duration).OnComplete(()=>Destroy(gameObject));
            if (CoinCounter.instance != null) CoinCounter.instance.AddCoin();
        }
    }
}
